#delimit ;

cap prog drop t3_setup ;
prog def t3_setup ;
syntax  ,  keylhs(string)  sourcedata(string) outdata(string) ;
di 123 ;
/* generate state policy variable */
use statefip using "`sourcedata'" , replace ;
contract statefip ;
set seed 10103 ;
generate sort_order = uniform() ;
sort sort_order ;
gen policy_st = _n <= 25 ;
sort statefip ;
drop sort_order _freq ;


tempfile statelist ;
qui save `statelist' ;


use "`sourcedata'" , replace ;

sort statefip ;
merge m:1  statefip using `statelist' ;
tab _merge ;
drop _merge ;

summ year ;
local yrmean = r(mean) ;
gen policy_yr = year >= `yrmean' ;
di "policy turns on starting in year >= `yrmean'" ;
gen policy = policy_st * policy_yr ;

/* generate state and year averages of the LHS variable and the policy variable */
egen `keylhs'_avg_s = mean(`keylhs') , by(statefip) ;
egen `keylhs'_avg_y = mean(`keylhs') , by(year) ;

egen policy_avg_s = mean(policy) , by(statefip) ;
egen policy_avg_y = mean(policy) , by(year) ;


/* generate deviations-from state and year FE variables for LHS and RHS.
	use those transformed variables in later regressions */
qui reg `keylhs' i.state i.year ;
predict `keylhs'_resid_styr , resid ;
qui reg policy i.state i.year ;
predict policy_resid_styr , resid ;

/* also residuals from year-only-FE models ... */
/* lnwage, lnwage_sy */
qui reg `keylhs' i.year ;
predict `keylhs'_resid_yr , resid ;
qui reg policy i.year ;
predict policy_resid_yr , resid ;

save `outdata' ;


end ;
